using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Data;
using Npgsql;
using System.Data.Common;
using PostgreDemo.Common;

namespace PostgreDemo.PostgreSQL
{
    /// <summary>
    /// 数据库帮助  
    /// </summary>
    public class PostgreHelper
    {
         private static string connectionString =appSettingHelper.GetConnValue("PostgreSqlDb");
        /// <summary>
        /// 得到数据条数  
        /// </summary>
        /// <param name="tblName">表名</param>
        /// <param name="condition">条件</param>
        /// <returns></returns>
  
        public int GetCount(string tblName, string condition)
        {
            try
            {
                StringBuilder sql = new StringBuilder("select count(*) from " + tblName);
                if (!string.IsNullOrEmpty(condition))
                    sql.Append(" where " + condition);

                object count = ExecuteScalar(CommandType.Text, sql.ToString(), null);
                return int.Parse(count.ToString());
            }
            catch
            {
                return -1;
            }
        } 
        
        /// <summary>
        /// 执行查询，返回DataSet
        /// </summary>
        /// <param name="cmdType">命令符</param>
        /// <param name="cmdText">命令文本</param>
        /// <param name="cmdParms">参数</param>
        /// <returns></returns>
        public DataSet ExecuteQuery(CommandType cmdType, string cmdText, params DbParameter[] cmdParms)
        {
            try
            {
                using (NpgsqlConnection conn = new NpgsqlConnection(connectionString))
                {
                    using (NpgsqlCommand cmd = new NpgsqlCommand())
                    {
                        PrepareCommand(cmd, conn, null, cmdType, cmdText, cmdParms);
                        using (NpgsqlDataAdapter da = new NpgsqlDataAdapter(cmd))
                        {
                            DataSet ds = new DataSet();
                            da.Fill(ds, "ds");
                            cmd.Parameters.Clear();
                            return ds;
                        }
                    }
                }
            }
            catch
            {
                return null;
            }
        }

       /// <summary>
        /// 在事务中执行查询，返回DataSet  
       /// </summary>
       /// <param name="trans">数据库连接</param>
       /// <param name="cmdType"></param>
       /// <param name="cmdText"></param>
       /// <param name="cmdParms"></param>
       /// <returns></returns>
 
        public DataSet ExecuteQuery(DbTransaction trans, CommandType cmdType, string cmdText, params DbParameter[] cmdParms)
        {
            try
            {
                NpgsqlCommand cmd = new NpgsqlCommand();
                PrepareCommand(cmd, trans.Connection, trans, cmdType, cmdText, cmdParms);
                NpgsqlDataAdapter da = new NpgsqlDataAdapter(cmd);
                DataSet ds = new DataSet();
                da.Fill(ds, "ds");
                cmd.Parameters.Clear();
                return ds;
            }
            catch
            {
                return null;
            }
        }

        /// <summary>
        /// 执行 Transact-SQL 语句并返回受影响的行数
        /// </summary>
        /// <param name="cmdType"></param>
        /// <param name="cmdText"></param>
        /// <param name="cmdParms"></param>
        /// <returns></returns>
  
        public int ExecuteNonQuery(CommandType cmdType, string cmdText, params DbParameter[] cmdParms)
        {
            NpgsqlCommand cmd = new NpgsqlCommand();
            try
            {
                using (NpgsqlConnection conn = new NpgsqlConnection(connectionString))
                {
                    PrepareCommand(cmd, conn, null, cmdType, cmdText, cmdParms);
                    int val = cmd.ExecuteNonQuery();
                    cmd.Parameters.Clear();
                    return val;
                }
            }
            catch
            {
                return -1;
            }
        }

        /// <summary>
        /// 在事务中执行 Transact-SQL 语句并返回受影响的行数
        /// </summary>
        /// <param name="trans"></param>
        /// <param name="cmdType"></param>
        /// <param name="cmdText"></param>
        /// <param name="cmdParms"></param>
        /// <returns></returns>
 
        public int ExecuteNonQuery(DbTransaction trans, CommandType cmdType, string cmdText, params DbParameter[] cmdParms)
        {
            try
            {
                NpgsqlCommand cmd = new NpgsqlCommand();
                PrepareCommand(cmd, trans.Connection, trans, cmdType, cmdText, cmdParms);
                int val = cmd.ExecuteNonQuery();
                cmd.Parameters.Clear();
                return val;
            }
            catch
            {
                return -1;
            }
        }

        /// <summary>
        /// 执行查询，返回DataReader  
        /// </summary>
        /// <param name="cmdType"></param>
        /// <param name="cmdText"></param>
        /// <param name="cmdParms"></param>
        /// <returns></returns>
  
        public DbDataReader ExecuteReader(CommandType cmdType, string cmdText, params DbParameter[] cmdParms)
        {
            NpgsqlCommand cmd = new NpgsqlCommand();
            NpgsqlConnection conn = new NpgsqlConnection(connectionString);

            try
            {
                PrepareCommand(cmd, conn, null, cmdType, cmdText, cmdParms);
                NpgsqlDataReader rdr = cmd.ExecuteReader(CommandBehavior.CloseConnection);
                cmd.Parameters.Clear();
                return rdr;
            }
            catch
            {
                conn.Close();
                throw;
            }
        }

       /// <summary>
        /// 在事务中执行查询，返回DataReader  
       /// </summary>
       /// <param name="trans"></param>
       /// <param name="cmdType"></param>
       /// <param name="cmdText"></param>
       /// <param name="cmdParms"></param>
       /// <returns></returns>
        public DbDataReader ExecuteReader(DbTransaction trans, CommandType cmdType, string cmdText, params DbParameter[] cmdParms)
        {
            NpgsqlCommand cmd = new NpgsqlCommand();
            try
            {
                PrepareCommand(cmd, trans.Connection, trans, cmdType, cmdText, cmdParms);
                NpgsqlDataReader rdr = cmd.ExecuteReader(CommandBehavior.CloseConnection);
                cmd.Parameters.Clear();
                return rdr;
            }
            catch
            {
                return null;
            }
        }
       
        /// <summary>
        /// 执行查询，并返回查询所返回的结果集中第一行的第一列。忽略其他列或行。  
        /// </summary>
        /// <param name="cmdType"></param>
        /// <param name="cmdText"></param>
        /// <param name="cmdParms"></param>
        /// <returns></returns>
        public object ExecuteScalar(CommandType cmdType, string cmdText, params DbParameter[] cmdParms)
        {
            NpgsqlCommand cmd = new NpgsqlCommand();
            try
            {
                using (NpgsqlConnection connection = new NpgsqlConnection(connectionString))
                {
                    PrepareCommand(cmd, connection, null, cmdType, cmdText, cmdParms);
                    object val = cmd.ExecuteScalar();
                    cmd.Parameters.Clear();
                    return val;
                }
            }
            catch
            {
                return null;
            }
        }

        /// <summary>
        /// 在事务中执行查询，并返回查询所返回的结果集中第一行的第一列。忽略其他列或行。
        /// </summary>
        /// <param name="trans"></param>
        /// <param name="cmdType"></param>
        /// <param name="cmdText"></param>
        /// <param name="cmdParms"></param>
        /// <returns></returns>
        public object ExecuteScalar(DbTransaction trans, CommandType cmdType, string cmdText, params DbParameter[] cmdParms)
        {
            NpgsqlCommand cmd = new NpgsqlCommand();
            try
            {
                PrepareCommand(cmd, trans.Connection, trans, cmdType, cmdText, cmdParms);
                object val = cmd.ExecuteScalar();
                cmd.Parameters.Clear();
                return val;
            }
            catch
            {
                return null;
            }
        }

         /// <summary>  
        /// 生成要执行的命令  
        /// </summary>  
        /// <remarks>参数的格式：冒号+参数名</remarks>  
        private static void PrepareCommand(DbCommand cmd, DbConnection conn, DbTransaction trans, CommandType cmdType,  string cmdText, DbParameter[] cmdParms)  
        {  
            if (conn.State != ConnectionState.Open)  
                conn.Open();  
  
            cmd.Connection = conn;  
            cmd.CommandText = cmdText.Replace("@", ":").Replace("?", ":").Replace("[", "\"").Replace("]", "\"");  
  
            if (trans != null)  
                cmd.Transaction = trans;  
  
            cmd.CommandType = cmdType;  
  
            if (cmdParms != null)  
            {  
                foreach (NpgsqlParameter parm in cmdParms)  
                {  
                    parm.ParameterName = parm.ParameterName.Replace("@", ":").Replace("?",":");  
  
                    cmd.Parameters.Add(parm);  
                }  
            }  
        }  
    }
}
