using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using System.Net.Http;
using PostgreDemo.BLL;
using PostgreDemo.Common;
using PostgreDemo.Model;

namespace PostgreDemoControllers
{
   [Route("[controller]")]
    public class userinfoController : Controller
    {
        private HttpResponseMessage WriteMsg(string Msg)
        {
            return new HttpResponseMessage { Content = new StringContent(Msg, System.Text.Encoding.UTF8, "application/json") };
        }
       userinfoBLL userbll=new  userinfoBLL();
      
      ///<summary>
      ///获取用户列表
      ///</summary>
       [HttpGet]
       [Route("GetALLList")]
       public HttpResponseMessage  GetALLList()
       {
           string strResult="";
           try
           {
                List<userinfo> getlist=userbll.GetALLList();
                if(getlist!=null)
                {
                    strResult=ConvertJson.ListToJson(getlist);
                }
                return WriteMsg(strResult);
           }
           catch 
           {
               return WriteMsg("fail");
           }
       }

      ///<summary>
      ///新增
      ///</summary>
      [HttpPut]
      [Route("Add")]
       public HttpResponseMessage Add()
       {
           string strResult="fail";
           string struserJson=Request.Form["AddUser"];//获取需要新增的用户信息
           try
           {
                userinfo item=JsonHelperT.JsonToEntity<userinfo>(struserJson);
                if(userbll.Add(item)){
                    strResult="success";
                }
                return WriteMsg(strResult);
           }
           catch 
           {
               return WriteMsg(strResult);
           }
       }

      ///<summary>
      ///更新
      ///</summary>
      [HttpPost]
      [Route("Update")]
       public HttpResponseMessage Update()
       {
           string strResult="fail";
           string struserJson=Request.Form["UpdateUser"];//获取需要新增的用户信息
           try
           {
                userinfo item=JsonHelperT.JsonToEntity<userinfo>(struserJson);
                if(userbll.Update(item)){
                    strResult="success";
                }
                return WriteMsg(strResult);
           }
           catch 
           {
               return WriteMsg(strResult);
           }
       }

      ///<summary>
      ///删除
      ///</summary>
      [HttpDelete]
      [Route("Delete")]
       public HttpResponseMessage Delete()
       {
           string strResult="fail";
           string strUserID=Request.Form["UserID"];//
           try
           {
                if(userbll.DeleteByID(strUserID)){
                    strResult="success";
                }
                return WriteMsg(strResult);
           }
           catch 
           {
               return WriteMsg(strResult);
           }
       }
       
    }
}