using System;
using System.Collections.Generic;
using Microsoft.Extensions.Configuration;
using System.IO;
using System.Linq;

namespace PostgreDemo.Common
{
    ///<summary>
    ///appsettingjson帮助
    ///</summary>
   public static  class appSettingHelper
   {
       ///<summary>
       ///构造函数
       ///</summary>
       static  appSettingHelper()
       {
           var  builder=new ConfigurationBuilder()
           .SetBasePath(Directory.GetCurrentDirectory())
           .AddJsonFile("appsettings.json",optional: true,reloadOnChange:true)
           .Build();
           Configuration=builder;
       }
       private  static IConfiguration Configuration { get; }

       ///<summary>
       ///获取数据库连接值
       ///</summary>
       ///<parameter name="KeyName"></parameter>
       ///<returns></returns>
       public static string GetConnValue(string KeyName)
       {
           string strReturnValue="";
           try
           {
               var keyvalue=Configuration.GetConnectionString(KeyName);
               if(keyvalue!=null)
               {
                    strReturnValue=keyvalue.ToString();
               }
           }
           catch
           {
               strReturnValue="";
           }
           return strReturnValue;
       }
       ///<summary>
       ///获取配置值
       ///</summary>
       ///<parameter name="KeyName"></parameter>
       ///<parameter name="NodeName"></parameter>
       ///<returns></returns>
       public static string GetSetValue(string KeyName,string NodeName)
       {
           string strReturnValue="";
           try
           {
               var keyvalue=Configuration.GetSection(KeyName);
               if(keyvalue!=null)
               {
                   var nodevalue=keyvalue[NodeName];
                   if(nodevalue!=null)
                   {
                       strReturnValue=nodevalue.ToString();
                   }
               }
           }
           catch
           {
               strReturnValue="";
           }
           return strReturnValue;
       }
   }
}