using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Data;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;

namespace PostgreDemo.Common
{
    ///<summary>
    ///Http请求帮助
    ///</summary>
   public static class HttpApi
   {
        /// <summary>
        /// 通过Get方式请求WebApi数据
        /// </summary>
        /// <param name="HttpUrl">api接口地址</param>
        /// <param name="Method">函数名称</param>
        /// <param name="GetData">Url参数</param>
        /// <returns>请求结果</returns>
        public static string Get(string HttpUrl,string Method, string GetData)
        {
            string ResultString = "fail";
            try
            {
                string Url = HttpUrl + Method+GetData;
                HttpWebRequest request = (HttpWebRequest)WebRequest.Create(Url + (GetData == "" ? "" : "?") + GetData);
                //HttpWebRequest request = (HttpWebRequest)WebRequest.Create(Url);
                request.Method = "GET";
                request.ContentType = "application/json;charset=UTF-8";

                HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                Stream myResponseStream = response.GetResponseStream();
                StreamReader myStreamReader = new StreamReader(myResponseStream);
                ResultString = myStreamReader.ReadToEnd();
                myStreamReader.Close();
                myResponseStream.Close();

            }
            catch
            { 
                
            }
            return ResultString;
        }


        /// <summary>
        ///  通过Post方式请求WebApi数据
        /// </summary>
        /// <param name="HttpUrl">api接口地址</param>
        /// <param name="Method">函数名称</param>
        /// <param name="PostData">以匿名对象方式提交Post数据，一般格式为 { A="A" }</param>
        /// <returns></returns>
        public static string Post<T>(string HttpUrl,string Method, T PostData)
        {
            string ResultString = "fail";
            string Url = HttpUrl + Method;
            try
            {
                WebClient WebClientObj = new WebClient();
                NameValueCollection PostVars = new NameValueCollection();

                //匿名对象转Json
                string JsonStr =JsonConvert.SerializeObject(PostData);
                if (!string.IsNullOrEmpty(JsonStr))
                {
                    //Json转dt 并加入到要发送数据的集合
                    // DataTable dt =JsonHelperT.JsonToDT(JsonStr);
                    // for (int i = 0; i < dt.Columns.Count; i++)
                    // {
                    //     PostVars.Add(dt.Columns[i].ColumnName, dt.Rows[0][i].ToString());
                    // }
                }
                byte[] byRemoteInfo = WebClientObj.UploadValues(Url, "POST", PostVars);
                ResultString = System.Text.Encoding.UTF8.GetString(byRemoteInfo);
            }
            catch { }
            return ResultString;
        }

        /// <summary>
        ///  通过Post方式请求WebApi数据
        /// </summary>
        /// <param name="HttpUrl">api接口地址</param>
        /// <param name="Method">函数名称</param>
        /// <param name="JsonPostData">"[{\"ParaName\":\"LogMsg\",\"ParaValue\":\"获取用户列表\"},{\"ParaName\":\"LogType\",\"ParaValue\":\"SerInfo\"}]"</param>
        /// <returns></returns>
        public static string Post(string HttpUrl,string Method, string JsonPostData)
        {
            string ResultString = "fail";
            string Url = HttpUrl + Method;
            try
            {
                WebClient WebClientObj = new WebClient();
                NameValueCollection PostVars = new NameValueCollection();

                //匿名对象转Json
                if (!string.IsNullOrEmpty(JsonPostData))
                {
                    //Json转List<T> 并加入到要发送数据的集合
                    List<Parameters> list =JsonHelperT.JonsToList<Parameters>(JsonPostData);
                    foreach (Parameters par in list)
                    {
                        PostVars.Add(par.ParaName,par.ParaValue.ToString());
                    }
                }
                byte[] byRemoteInfo = WebClientObj.UploadValues(Url, "POST", PostVars);
                ResultString = System.Text.Encoding.UTF8.GetString(byRemoteInfo);
            }
            catch { }
            return ResultString;
        }

        ///<summary>
        ///Post 传输参数实体类
        ///</summary>
        private  class Parameters
        {
            ///<summary>
            ///参数名称
            ///</summary>
             public string ParaName{get;set;}
             ///<summary>
             ///参数值
             ///</summary>
             public object ParaValue{get;set;}
        }
   }
}